<?php
namespace boru\cli\params;

class Param {
    
    /**
     * Create a Flag parameter, Flag parameters take no value
     * @param mixed $syntaxString syntax string: *d|debug|Enable debug mode
     * @param array $config extra options
     * @return Flag 
     */
    public static function flag($syntaxString=null,$config=[]) {
        return Flag::create($syntaxString,$config);
    }

    /**
     * Create an Option parameter, Option parameters take a value
     * @param mixed $syntaxString syntax string: *f|file|File to read from
     * @param array $config extra options
     * @return Option 
     */
    public static function option($syntaxString=null,$config=[]) {
        return Option::create($syntaxString,$config);
    }

    /**
     * Create a Positional parameter, Positional parameters take a value, and have no short name
     * @param mixed $syntaxString syntax string: file|File to read from
     * @param array $config extra options
     * @return Positional 
     */
    public static function positional($syntaxString=null,$config=[]) {
        return Positional::create($syntaxString,$config);
    }
}