<?php
namespace boru\cli\printer;

class Line {
    private $type = "line";
    private $text;
    private $parts = [];
    private $printer;

    private $wrapped = false;

    public function __construct($text,$type="line",$printer) {
        if(!is_array($text)) {
            $text = [$text];
        }
        $this->parts = $text;
        $this->type = $type;
        $this->printer = $printer;
    }
    public function type($type=null) {
        if($type === null) {
            return $this->type;
        }
        $this->type = $type;
        return $this;
    }
    public function text($text=null) {
        if($text === null) {
            if($this->text === null) {
                $this->wrap();
            }
            return $this->text;
        }
        if(is_array($text)) {
            $this->parts = $text;
            return $this;
        }
        $this->parts = [$text];
        return $this;
    }
    /**
     * @param null|Printer $printer
     * @return Printer
     */
    public function printer($printer=null) {
        if($printer === null) {
            return $this->printer;
        }
        $this->printer = $printer;
        return $this;
    }
    public function __toString() {
        $this->wrap();
        return $this->text;
    }
    public function preParse() {
        $replace = [
            "{INDENT}"      => $this->makeIndent(),
        ];
        foreach($replace as $key => $value) {
            foreach($this->parts as $k=>$part) {
                $this->parts[$k] = str_replace($key,$value,$part);
            }
        }
        if($this->type == "line") {
            return $this;
        }
    }
    public function parse($force=false) {
        if($this->text !== null && !$force) {
            return $this;
        }
        
        $short = "";
        $long  = "";
        $parts = $this->parts;
        $this->text = $short.$long.implode(" ",$parts);
        $length = strlen($this->text)+2;
        //$this->printer->set("maxLength",max($this->printer->get("maxLength",0),$length));
        $this->printer()->registerLength($length);
        $this->wrap();
        return $this;
    }
    public function postParse() {
        $replace = [
            "{SEPARATOR}"   => $this->makeSeparator("-"),
            "{SEPARATOR_}"  => $this->makeSeparator("_"),
            "{SEPARATOR=}"  => $this->makeSeparator("="),
            "{HEADER}"      => $this->makeSeparator("="),
            "{FOOTER}"      => $this->makeSeparator("="),
        ];
        foreach($replace as $key=>$value) {
            $this->text = str_replace($key,$value,$this->text);
        }
    }
    private function wrap($force=false) {
        if($this->wrapped && !$force) {
            return $this->text;
        }
        $maxCols = $this->get("maxCols",0);
        $spacing = 0;
        if($maxCols == 0) {
            return $this->text;
        }
        $this->text = wordwrap($this->text,$maxCols-$spacing,"\n");

        $array = explode("\n",$this->text);
        if($spacing>0) {
            $array = array_map(function($line) use ($spacing) {
                return str_repeat(" ",$spacing).$line;
            },$array);
        }
        $this->text = implode("\n",$array);
        $this->wrapped = true;
        return $this->text;
    }

    public function get($key,$default=null) {
        return $this->printer->get($key,$default);
    }
    
    public function makeIndent($length=null) {
        return $this->printer->makeIndent($length);
    }
    public function makeSeparator($char="-",$length=null) {
        return $this->printer->makeSeparator($char,$length);
    }
    public static function line($text,$printer=null) {
        return new Line($text,"line",$printer);
    }
}