<?php
namespace boru\cli\printer;

class Lines {
    private $printer;
    private $lines = [];
    public function __construct($printer) {
        $this->printer = $printer;
    }

    public function parse() {
        foreach($this->lines as $line) {
            $line->preParse();
        }
        foreach($this->lines as $line) {
            $line->parse();
        }
        foreach($this->lines as $line) {
            $line->postParse();
        }
        return $this->lines;
    }

    public function lines($newPrinter=null) {
        if($newPrinter === null) {
            return $this->lines;
        }
        foreach($this->lines as $line) {
            $line->printer($newPrinter);
        }
        return $this->lines;
    }

    public function fromLines($lines,$merge=true) {
        if($lines instanceof Lines) {
            $lines = $lines->lines();
        }
        if(!$merge) {
            $this->lines = [];
        }
        foreach($lines as $line) {
            $this->addLine($line);
        }
        return $this;
    }
    
    
    public function addSeparator() {
        $this->addLine("{SEPARATOR}");
    }
    public function addLine($text,$type="line") {
        if($text instanceof Line) {
            $text->printer($this->printer);
            $this->lines[] = $text;
            return $this;
        }
        if($text instanceof Table) {
            $this->lines[] = new TableLine($text,$this->printer);
            return $this;
        }
        $this->lines[] = new Line($text,$type,$this->printer);
        return $this;
    }

    public function line($text) {
        $this->lines[] = Line::line($text,$this->printer);
    }
    public function table($table) {
        $tableLine = new TableLine($table,$this->printer);
        $this->lines[] = $tableLine;
    }
}