<?php
// smoke/cli/_bootstrap_objects.php
//
// Build and return a CLI instance configured with the new
// CommandInterface + capability-based API, and a BufferOutput
// for smoke tests.

require __DIR__ . '/../../vendor/autoload.php';

use boru\cli2\CLI;
use boru\cli2\Output\BufferOutput;
use boru\cli2\Params\Flag;
use boru\cli2\Smoke\SmokeUserGroup;
use boru\cli2\Smoke\SmokeUserAddCommand;
use boru\cli2\Smoke\SmokeDeployCommand;

/**
 * @return array [CLI $cli, BufferOutput $buffer]
 */
return (function () {
    $cli = CLI::create('app-objects|CLI2 object-based smoke test');

    // Use buffer output for assertions
    $buffer = new BufferOutput();
    $cli->output($buffer);

    // Baseline root params defined directly (like before)
    $cli->params(array(
        Flag::create('v|verbose|Verbose output (from bootstrap)'),
    ));

    // Register a group and commands using the new sugar:
    $cli
        ->register(new SmokeUserGroup())
        ->register(new SmokeUserAddCommand())
        ->register(new SmokeDeployCommand());

    return array($cli, $buffer);
})();
