<?php
namespace boru\cli2\Output;

/**
 * Output implementation that buffers lines in-memory.
 * Useful for smoke tests and programmatic use.
 */
class BufferOutput implements OutputInterface
{
    /** @var string[] */
    protected $lines = array();

    public function line($message, $context = null)
    {
        if ($context !== null) {
            $message .= ' ' . var_export($context, true);
        }
        $this->lines[] = $message;
    }

    /**
     * @return string[] all lines written so far
     */
    public function lines()
    {
        return $this->lines;
    }

    /**
     * @return string joined lines with PHP_EOL
     */
    public function asString()
    {
        return implode(PHP_EOL, $this->lines);
    }

    public function clear()
    {
        $this->lines = array();
    }
}
