<?php
// smoke/cli/SmokeDeployCommand.php

namespace boru\cli2\Smoke;

use boru\cli2\CommandInterface;
use boru\cli2\CommandDescriptionInterface;
use boru\cli2\RouteParamsInterface;
use boru\cli2\CLIContext;
use boru\cli2\Params\Flag;
use boru\cli2\Params\Option;

/**
 * deploy
 *
 * Root-level command with its own params via capabilities.
 */
class SmokeDeployCommand implements
    CommandInterface,
    CommandDescriptionInterface,
    RouteParamsInterface
{
    public function name()
    {
        return 'deploy';
    }

    public function description()
    {
        return 'Deploy the app (object-based)';
    }

    public function routeParams()
    {
        return array(
            Flag::create('f|force|Force deployment (object-based)'),
            Option::create('e|env|Environment name (object-based)'),
        );
    }

    public function handle(CLIContext $ctx)
    {
        $ctx->output("SmokeDeployCommand invoked");
        $ctx->output('Global params: ' . var_export($ctx->globalParams(), true));
        $ctx->output('Route params: ' . var_export($ctx->params(), true));
        $ctx->output('Route path: ' . implode(' ', $ctx->routePath()));
    }
}
