#!/usr/bin/env php
<?php
$bundle = require __DIR__ . '/_bootstrap.php';
list($cli, $buffer) = $bundle;
require __DIR__ . '/_assert.php';

$label = '002_deploy_force';

// Run
$buffer->clear();
$cli->parse('deploy -f --env=prod');

$output = implode("\n", $buffer->lines());

$exp = array(
    'Deploy command invoked',
    'env\' => \'prod\'',  // crude check that env=prod ended up in params
);
$no  = array('Errors:');

$res1 = assert_contains_all($output, $exp, $label);
$res2 = assert_not_contains_any($output, $no, $label);

if (!$res1['ok'] || !$res2['ok']) {
    fwrite(STDERR, (!$res1['ok'] ? $res1['message'] : $res2['message']) . "\n");
    exit(1);
}

fwrite(STDOUT, $label . " OK\n");
exit(0);
