<?php
namespace boru\cli2;

use boru\cli2\Models\RouteNode;
use boru\cli2\Models\CommandRouter;
use boru\cli2\CLIContext;

use boru\cli2\Models\Args;
use boru\cli2\Models\Params;
use boru\cli2\Output\OutputInterface;
use boru\cli2\Output\StdOutput;

use boru\cli2\CommandInterface;
use boru\cli2\CommandGroupInterface;
use boru\cli2\ParentPathInterface;
use boru\cli2\CommandDescriptionInterface;
use boru\cli2\RouteParamsInterface;
use boru\cli2\GroupParamsInterface;
use boru\cli2\RootParamsInterface;

use boru\cli2\Traits\ClassCommandTrait;

/**
 * Router-based CLI v2.
 */
class CLI extends CoreCLI
{
    use ClassCommandTrait;
    public function __construct($syntaxOrArray = '', $params = null)
    {
        parent::__construct($syntaxOrArray, $params);
    }

    public static function create($syntaxOrArray = '', $params = null)
    {
        return new static($syntaxOrArray, $params);
    }

    /**
     * Get or set the output implementation.
     *
     * @param OutputInterface|null $output
     * @return OutputInterface|$this
     */
    public function output(OutputInterface $output = null)
    {
        return parent::output($output);
    }

    public function name($name = null)
    {
        return parent::name($name);
    }

    public function description($description = null)
    {
        return parent::description($description);
    }

    /**
     * Get the underlying CommandRouter.
     *
     * @return CommandRouter
     */
    public function getRouter()
    {
        return parent::getRouter();
    }

    /**
     * Get the root RouteNode for this CLI2 instance.
     *
     * @return RouteNode
     */
    public function getRootNode()
    {
        return parent::getRootNode();
    }

    /**
     * Root/global params for CLI2.
     *
     * @param Params|array|null $params
     * @return Params
     */
    public function params($params = null)
    {
        return parent::params($params);
    }

    /**
     * Define a route (leaf command).
     *
     * @param string|string[] $pathOrSyntax e.g. 'deploy' or 'user add' or 'cmd|A test command'
     * @param array|Params|null $params
     * @param callable|null $handler
     * @return $this
     */
    public function route($pathOrSyntax, $params = null, $handler = null)
    {
        return parent::route($pathOrSyntax, $params, $handler);
    }

    /**
     * Define a group of routes under a common prefix.
     *
     * Usage:
     *   $cli->group('user|User commands', function ($group) {
     *       $group->route('add', [...], $cb);
     *   });
     *
     * @param string|string[] $pathOrSyntax
     * @param callable|null $builder
     * @return $this
     */
    public function group($pathOrSyntax, $builder = null)
    {
        return parent::group($pathOrSyntax, $builder);
    }

    /**
     * Parse and dispatch.
     *
     * @param array|string|null $args
     * @return mixed
     * @throws \Exception
     */
    public function parse($args = null)
    {
        return parent::parse($args);
    }


    /**
     * Resolve route and parse params at each scope (root, groups, leaf).
     *
     * Walks the route tree starting at rootNode:
     *  - At each node with Params, runs parse() (with ignoreUnexpected set by caller),
     *  - Then uses remaining unused tokens to decide which child to descend into.
     *
     * Returns array: [RouteNode $node, array $globalResults, array $scopeResults, array $routeResults]
     *
     * For now:
     *  - "globalResults" = root params.
     *  - "scopeResults"  = merged group/subgroup params.
     *  - "routeResults"  = leaf command params.
     *
     * @param Args $args
     * @return array
     */
    protected function resolveRouteAndParams(Args $args)
    {
        return parent::resolveRouteAndParams($args);
    }

    protected function printErrors($errors)
    {
        // small, simple error output; can be made nicer
        $this->output->line("Errors:");
        foreach ((array)$errors as $err) {
            $this->output->line(" - " . $err);
        }
    }

    public function printNamespaceHelp($namespace)
    {
        parent::printNamespaceHelp($namespace);
    }

    /**
     * Print help for a specific RouteNode.
     *
     * - If it's root: same as printHelp()
     * - If it has children and no handler: namespace help
     * - If it has a handler: a simple one-line description and, optionally,
     *   list params (we can enhance later)
     *
     * @param RouteNode $node
     * @return void
     */
    protected function printNodeHelp(RouteNode $node)
    {
        if ($node === $this->rootNode) {
            $this->printHelp();
            return;
        }

        $hasChildren = !empty($node->children());
        $handler     = $node->handler();

        if ($hasChildren && $handler === null) {
            $this->printNamespaceHelp(implode(' ', $node->path()));
            return;
        }

        // Leaf or node with handler: simple command help for now
        $path = implode(' ', $node->path());
        $this->output->line($path . ' - ' . $node->description());
        // TODO: later we can introspect Params for this node and print usage/options.
    }

    /**
     * Public API to display help for an optional path.
     *
     * @param string|string[]|null $path
     * @return void
     */
    public function help($path = null)
    {
        if ($path === null || $path === '' || $path === false) {
            $this->printHelp();
            return;
        }

        if (!is_array($path)) {
            $path = preg_split('/\s+/', trim((string)$path));
        }

        $node = $this->findNode($path);
        if (!$node instanceof RouteNode) {
            $this->output->line('Unknown command or group: ' . (is_array($path) ? implode(' ', $path) : $path));
            return;
        }

        $this->printNodeHelp($node);
    }

}
