<?php
namespace boru\cli2\Output;

/**
 * Default output implementation that writes to STDOUT.
 */
class StdOutput implements OutputInterface
{
    /** @var bool */
    protected $showContext = true;

    public function __construct($showContext = true)
    {
        $this->showContext = (bool)$showContext;
    }

    public function line($message, $context = null)
    {
        if ($context !== null && $this->showContext) {
            // Very simple context dumping; can be refined later.
            $message .= ' ' . var_export($context, true);
        }

        fwrite(STDOUT, $message . PHP_EOL);
    }
}
