<?php
namespace boru\cli2\Params;

class Option extends Param
{
    public function __construct($name = null, $short = null, $description = '')
    {
        parent::__construct($name, $short, $description);
        $this->takesValue(true);
    }

    /**
     * Factory from syntax string like "*b|book+|Book or books".
     *
     * @param string $syntax
     * @return static
     */
    public static function create($syntax)
    {
        $def = ParamSyntax::parse($syntax);

        $opt = new static($def['name'], $def['short'], $def['description']);
        $opt->required($def['required']);
        $opt->multiple($def['multiple']);
        $opt->takesValue(true);

        return $opt;
    }
}
