#!/usr/bin/env php
<?php
$bundle = require __DIR__ . '/_bootstrap.php';
list($cli, $buffer) = $bundle;
require __DIR__ . '/_assert.php';

$label = '006_user_update';

// Run
$buffer->clear();
$cli->parse('user update alice -f email -v new@example.com');

$output = implode("\n", $buffer->lines());

$exp = array(
    'User update command invoked',
    '\'name\' => \'alice\'',
    '\'field\' => \'email\'',
    '\'value\' => \'new@example.com\'',
);
$no  = array('Errors:');

$res1 = assert_contains_all($output, $exp, $label);
$res2 = assert_not_contains_any($output, $no, $label);

if (!$res1['ok'] || !$res2['ok']) {
    fwrite(STDERR, (!$res1['ok'] ? $res1['message'] : $res2['message']) . "\n");
    exit(1);
}

fwrite(STDOUT, $label . " OK\n");
exit(0);
