<?php
namespace boru\cli2\Commands;

use boru\cli2\CommandInterface;
use boru\cli2\CommandDescriptionInterface;
use boru\cli2\CommandParamsInterface;
use boru\cli2\CLIContext;
use boru\cli2\Models\RouteNode;
use boru\cli2\Params\Positional;

/**
 * help [topic...]
 *
 * Examples:
 *   help
 *   help user
 *   help user add
 */
class HelpCommand implements
    CommandInterface,
    CommandDescriptionInterface,
    CommandParamsInterface
{
    public function name()
    {
        return 'help';
    }

    public function description()
    {
        return 'Show help for a command or namespace';
    }

    public function commandParams()
    {
        // One positional that can contain “user”, “user add”, etc.
        // You can refine this later to be multiple positionals if you want.
        return array(
            Positional::create('topic|Command or group to show help for'),
        );
    }

    public function handle(CLIContext $ctx)
    {
        $cli = $ctx->cli(); // assuming CLIContext exposes it

        $params = $ctx->params();
        $topic  = isset($params['topic']) ? trim($params['topic']) : '';

        if ($topic === '') {
            $cli->help();
        } else {
            $cli->help($topic);
        }
    }

}
