<?php
namespace boru\cli2;

/**
 * Capability: command knows which parent path (group namespace) it lives under.
 */
interface ParentPathInterface
{
    /**
     * Parent path (excluding leaf name).
     *
     * Examples:
     *   null / false => root-level
     *   "user"       => user <name()>
     *   "user admin" => user admin <name()>
     *   ["user"]     => user <name()>
     *   ["user","admin"] => user admin <name()>
     *
     * @return string|string[]|null|false
     */
    public function parentPath();
}
