<?php
// smoke/cli/_assert.php

/**
 * Assert that all expected substrings appear in $output.
 *
 * @param string   $output
 * @param string[] $expected
 * @param string   $label
 * @return array [ok => bool, message => string]
 */
function assert_contains_all($output, array $expected, $label)
{
    $failures = array();
    foreach ($expected as $exp) {
        if ($exp === '') {
            continue;
        }
        if (strpos($output, $exp) === false) {
            $failures[] = "Missing expected substring: '{$exp}'";
        }
    }

    if (!empty($failures)) {
        return array(
            'ok'      => false,
            'message' => $label . " FAILED:\n  - " . implode("\n  - ", $failures) . "\n\nActual output:\n" . $output,
        );
    }

    return array('ok' => true, 'message' => $label . " OK");
}

/**
 * Assert that none of the forbidden substrings appear in $output.
 */
function assert_not_contains_any($output, array $forbidden, $label)
{
    $failures = array();
    foreach ($forbidden as $no) {
        if ($no === '') {
            continue;
        }
        if (strpos($output, $no) !== false) {
            $failures[] = "Unexpected substring present: '{$no}'";
        }
    }

    if (!empty($failures)) {
        return array(
            'ok'      => false,
            'message' => $label . " FAILED:\n  - " . implode("\n  - ", $failures) . "\n\nActual output:\n" . $output,
        );
    }

    return array('ok' => true, 'message' => $label . " OK");
}
