<?php
// smoke/cli/_bootstrap.php

require __DIR__ . '/../../vendor/autoload.php';

use boru\cli2\CLI;
use boru\cli2\CLIContext;
use boru\cli2\Params\Flag;
use boru\cli2\Params\Option;
use boru\cli2\Params\Positional;
use boru\cli2\Output\BufferOutput;

/**
 * Build and return a CLI instance and attached BufferOutput.
 *
 * @return array [CLI $cli, BufferOutput $buffer]
 */
return (function () {
    $cli = CLI::create('app|CLI2 smoke test');

    // Use buffer output for assertions
    $buffer = new BufferOutput();
    $cli->output($buffer);

    // Global params: -d / --debug
    $cli->params(array(
        Flag::create('d|debug|Enable debug'),
    ));

    // user group with group-level -u / --username
    $cli->group('user|User commands', function ($user) {

        // Group-level params: apply to all user commands
        $user->params(array(
            Option::create('u|username|Default username'),
        ));

        // user add <name>
        $user->route('add|Add a user', array(
            Positional::create('name|Name of user'),
        ), function (CLIContext $ctx) {
            $ctx->output("User add command invoked");
            $ctx->output('Global params: ' . var_export($ctx->globalParams(), true));
            $ctx->output('Route params: ' . var_export($ctx->params(), true));
        });

        // user update <name> -f field -v value
        $user->route('update|Update a user', array(
            Positional::create('name|Name of user'),
            Option::create('f|field|Field to update'),
            Option::create('v|value|New value'),
        ), function (CLIContext $ctx) {
            $ctx->output("User update command invoked");
            $ctx->output('Global params: ' . var_export($ctx->globalParams(), true));
            $ctx->output('Route params: ' . var_export($ctx->params(), true));
        });
    });

    // Deploy command
    $cli->route('deploy|Deploy the app', array(
        Flag::create('f|force|Force deployment'),
        Option::create('e|env|Environment name'),
    ), function (CLIContext $ctx) {
        $ctx->output("Deploy command invoked");
        $ctx->output('Global params: ' . var_export($ctx->globalParams(), true));
        $ctx->output('Route params: ' . var_export($ctx->params(), true));
    });

    return array($cli, $buffer);
})();
