#!/usr/bin/env php
<?php
$base = __DIR__ . '/cli';

$tests = glob($base . '/[0-9][0-9][0-9]_*.php');
sort($tests);

if (empty($tests)) {
    fwrite(STDERR, "No tests found in smoke/cli\n");
    exit(1);
}

$allOk = true;

foreach ($tests as $test) {
    $label = basename($test);
    $cmd   = escapeshellcmd(PHP_BINARY) . ' ' . escapeshellarg($test);
    exec($cmd, $outLines, $code);

    if ($code !== 0) {
        $allOk = false;
        fwrite(STDERR, "--- {$label} FAILED ---\n");
        if (!empty($outLines)) {
            fwrite(STDERR, implode("\n", $outLines) . "\n");
        }
    } else {
        fwrite(STDOUT, implode("\n", $outLines) . "\n");
    }
}

exit($allOk ? 0 : 1);
