<?php
namespace boru\cli2\Params;

class Flag extends Param
{
    public function __construct($name = null, $short = null, $description = '')
    {
        parent::__construct($name, $short, $description);
        $this->takesValue(false);
    }

    /**
     * Factory from syntax string like "*f|flag|Required flag".
     *
     * @param string $syntax
     * @return static
     */
    public static function create($syntax)
    {
        $def = ParamSyntax::parse($syntax);

        $flag = new static($def['name'], $def['short'], $def['description']);
        $flag->required($def['required']);
        $flag->multiple($def['multiple']);
        $flag->takesValue(false);

        return $flag;
    }

    /**
     * Override setFlag if we ever want special behavior.
     */
    public function setFlag()
    {
        return parent::setFlag();
    }
}
