<?php
// smoke/cli/SmokeUserGroup.php

namespace boru\cli2\Smoke;

use boru\cli2\CommandGroupInterface;
use boru\cli2\CommandGroupCommandsInterface;
use boru\cli2\CLIGroup;
use boru\cli2\Smoke\SmokeUserAddCommand;

/**
 * Simple user group for object-based smoke tests.
 *
 * Demonstrates CommandGroupInterface used alongside command capabilities.
 */
class SmokeUserGroup implements CommandGroupInterface, CommandGroupCommandsInterface
{
    public function name()
    {
        return 'user';
    }

    public function description()
    {
        return 'User commands (object-based smoke)';
    }

    public function registerGroupCommands(CLIGroup $group)
    {
        // SmokeUserAddCommand does NOT need ParentPathInterface to be under "user"
        $group->register(new SmokeUserAddCommand());
    }
}
