#!/usr/bin/env php
<?php
$bundle = require __DIR__ . '/_bootstrap.php';
list($cli, $buffer) = $bundle;
require __DIR__ . '/_assert.php';

$label = '001_root_help';

// Run
$buffer->clear();
$cli->parse('');

// Build output string
$output = implode("\n", $buffer->lines());

// Expectations
$exp  = array(
    'app - CLI2 smoke test',
    'Available commands:',
    'user  -  User commands',
    'user add  -  Add a user',
    'user update  -  Update a user',
    'deploy  -  Deploy the app',
);
$no   = array('Errors:');

$res1 = assert_contains_all($output, $exp, $label);
$res2 = assert_not_contains_any($output, $no, $label);

if (!$res1['ok'] || !$res2['ok']) {
    fwrite(STDERR, (!$res1['ok'] ? $res1['message'] : $res2['message']) . "\n");
    exit(1);
}

fwrite(STDOUT, $label . " OK\n");
exit(0);
