#!/usr/bin/env php
<?php
$bundle = require __DIR__ . '/_bootstrap.php';
list($cli, $buffer) = $bundle;
require __DIR__ . '/_assert.php';

$label = '005_user_add_with_globals';

// Run
$buffer->clear();
$cli->parse('-d user --username bob add charlie');

$output = implode("\n", $buffer->lines());

$exp = array(
    'User add command invoked',
    '\'debug\' => true',       // from root params
    '\'username\' => \'bob\'', // from user group params
    '\'name\' => \'charlie\'', // route positional
);
$no  = array('Errors:');

$res1 = assert_contains_all($output, $exp, $label);
$res2 = assert_not_contains_any($output, $no, $label);

if (!$res1['ok'] || !$res2['ok']) {
    fwrite(STDERR, (!$res1['ok'] ? $res1['message'] : $res2['message']) . "\n");
    exit(1);
}

fwrite(STDOUT, $label . " OK\n");
exit(0);
