<?php
namespace boru\cli2\Contracts;

use boru\cli2\CLIGroup;

/**
 * Capability: a command group can register its own commands under its namespace.
 *
 * Implementations can use this to attach one or more CommandInterface
 * instances to the CLI when the group itself is registered.
 */
interface CommandGroupCommandsInterface
{
    /**
     * Register this group's commands under the given CLIGroup.
     *
     * The CLIGroup represents this group's namespace (e.g. "user"),
     * so commands registered here will be routed beneath it by default
     * if they do not implement ParentPathInterface.
     *
     * @param CLIGroup $group
     * @return void
     */
    public function registerGroupCommands(CLIGroup $group);
}
