<?php
namespace boru\cli2\Contracts;

use boru\cli2\CLIContext;

/**
 * Minimal command: name + handler.
 *
 * Capabilities (optional extra interfaces) can extend this with
 * description, parent path, params at various scopes, etc.
 */
interface CommandInterface
{
    /**
     * Leaf command name, e.g. "deploy", "ban".
     *
     * @return string
     */
    public function name();

    /**
     * Execute the command.
     *
     * @param CLIContext $ctx
     * @return mixed
     */
    public function handle(CLIContext $ctx);
}
