<?php
namespace boru\cli2\Params;

class Positional extends Param
{
    public function __construct($name = null, $description = '')
    {
        // For positionals we treat $name as long-name, no short alias.
        parent::__construct($name, null, $description);
        $this->takesValue(true);
    }

    /**
     * Factory from syntax string like "*file|File to process"
     * or "files+|Files to process".
     *
     * @param string $syntax
     * @return static
     */
    public static function create($syntax)
    {
        $def = ParamSyntax::parsePositional($syntax);

        $pos = new static($def['name'], $def['description']);
        $pos->required($def['required']);
        $pos->multiple($def['multiple']);
        $pos->takesValue(true);

        return $pos;
    }
}
