<?php
// smoke/cli/SmokeUserAddCommand.php

namespace boru\cli2\Smoke;

use boru\cli2\Contracts\CommandInterface;
use boru\cli2\Contracts\CommandDescriptionInterface;
use boru\cli2\Contracts\CommandParamsInterface;
use boru\cli2\Contracts\GroupParamsInterface;
use boru\cli2\Contracts\RootParamsInterface;
use boru\cli2\CLIContext;
use boru\cli2\Params\Flag;
use boru\cli2\Params\Option;
use boru\cli2\Params\Positional;

/**
 * user add <name>
 *
 * Demonstrates:
 *  - parentPath() placing it under "user"
 *  - routeParams() for leaf args
 *  - groupParams() contributing a shared -u/--username
 *  - rootParams() contributing a global -d/--debug
 */
class SmokeUserAddCommand implements
    CommandInterface,
    CommandDescriptionInterface,
    CommandParamsInterface,
    GroupParamsInterface,
    RootParamsInterface
{
    public function name()
    {
        return 'add';
    }

    public function description()
    {
        return 'Add a user (object-based)';
    }

    /*public function parentPath()
    {
        // Could also be ['user']; both work
        return 'user';
    }*/

    public function commandParams()
    {
        return array(
            Positional::create('*name|Name of user'),
        );
    }

    public function groupParams()
    {
        // Same idea as your closure-based example: -u/--username at user group level
        return array(
            Option::create('u|username|Default username (from object-based user group)'),
        );
    }

    public function rootParams()
    {
        // Contribute a global debug flag
        return array(
            Flag::create('d|debug|Enable debug (from object-based command)'),
        );
    }

    public function handle(CLIContext $ctx)
    {
        $ctx->output("SmokeUserAddCommand invoked");
        $ctx->output('Global params: ' . var_export($ctx->globalParams(), true));
        $ctx->output('Route params: ' . var_export($ctx->params(), true));
        $ctx->output('Context Data: ' . var_export($ctx->getData(), true));
        $ctx->output('Route path: ' . implode(' ', $ctx->routePath()));
    }
}
