<?php
namespace boru\dhapi\autoloaders;

use boru\dhapi\AutoloaderInterface;
use \boru\dhutils\dhGlobal;
use boru\dhutils\dhLoader;

class ClassPathLoader implements AutoloaderInterface {
    public function init($api) {
        dhLoader::baseDir($api->getBaseDir());
        spl_autoload_register(
            [$this, 'load']
        );
    }
    public function load($className) {
        $parts = explode("_",strtolower($className));
        //utilize dhLoader for the including parts..
        dhLoader::includeOnce(implode(".",$parts));
        if(!class_exists($className)) {
            echo json_encode(["error"=>true]);
            exit();
        }
    }
}