<?php
namespace boru\dhapi\routers;

use boru\dhapi\RouterInterface;
use \boru\dhutils\dhGlobal;

class ClassPathRouter implements RouterInterface {
    public function route($api) {
        if(($path = $api->getQuery("PATH",false)) !== false) {
            $path = dhGlobal::trimString("/",    $path,dhGlobal::TRIM_BOTH);
            $path = dhGlobal::trimString(".php", $path,dhGlobal::TRIM_END);
            $path = ucwords($path,"/");
            $parts = explode("/",$path);
            $handlerClass = implode("_",$parts);
            return ["class"=>$handlerClass,"args"=>[]];
        }
    }
}