<?php
namespace boru\dhapi\routers;

use boru\dhapi\RouterInterface;
use boru\dhutils\dhGlobal;
use boru\dhutils\traits\GetSetArray;

class RegExRouter implements RouterInterface {
    protected $routes = [];
    protected $default;
    public function __construct() {
        
    }
    
    public function route($api) {
        if(($path = $api->getQuery("PATH",false)) !== false) {
            $path = dhGlobal::trimString("/",    $path,dhGlobal::TRIM_BOTH);
            $path = dhGlobal::trimString(".php", $path,dhGlobal::TRIM_END);
            foreach($this->routes as $regex=>$className) {
                if(preg_match($regex,$path,$matches) !== 0) {
                    array_shift($matches);
                    return ["class"=>$className,"args"=>$matches];
                }
            }
        }
        if(!is_null($this->default)) {
            $className = $this->default;
            return ["class"=>$className,"args"=>[]];
        }
        return false;
    }

    public function addRoute($regex,$className) {
        $this->routes[$regex]=$className;
        return $this;
    }

    /**
     * Set the value of default
     *
     * @param   mixed  $default  
     * @return  self
     */
    public function defaultRoute($default) {
        $this->default = $default;
        return $this;
    }
}