<?php
namespace boru\dhapi\v2;

use boru\dhapi\v2\core\Response;
use boru\dhapi\v2\interfaces\ClassControllerInterface;

class ClassController implements ClassControllerInterface {
    protected $API;
    public function setAPI($API) {
        $this->API = $API;
    }
    public function isPermissed($API,$route) {
        return true;
    }

    /**
     * Returns an array of routes for the given method
     * * The indexed array should have values that are either Route objects, or in the following fromat:
     * * [
     * * * "path", // The path to match, eg "/hello/world/{id}"
     * * * ["GET","POST",...], // The methods to match, eg ["GET","POST","PUT","DELETE"]
     * * * "functionName" // The name of the function to call, eg "helloWorld"
     * * * true // Whether or not to require an authentication response other than false
     * * ],
     * @param string $method
     * @return array
     */
    public function routes() {
        return [
            ["/hello/world",["GET"],"helloWorld"],
            ["/hello/world/{idlist}",["GET"],"helloWorldWithIds"],
            ["/test/{id:idlist}",["GET","POST"], "testFunction",true],
        ];
    }

    public function helloWorld() {
        return Response::fromSuccess(["message"=>"Hello World!"]);
    }
    public function helloWorldWithIds($args) {
        return Response::fromSuccess(["message"=>"Hello World!","args"=>$args]);
    }
    public function testFunction($args) {
        return Response::fromSuccess(["message"=>"test/endpoint2!","args"=>$args,"apiArgs"=>$this->API->body()]);
    }
}