<?php
namespace boru\dhapi\v2\auth;

use boru\dhapi\v2\core\Response;
use boru\dhapi\v2\interfaces\AuthenticatorInterface;

class CallbackAuthenticator implements AuthenticatorInterface {
    private $callback = null;
    private $permissedCallback = null;
    private $authed = false;
    public function __construct($callback=null,$permissedCallback=null) {
        $this->callback = $callback;
        $this->permissedCallback = $permissedCallback;
    }
    public function authenticate($API) {
        if(is_null($this->callback)) {
            return false;
        }
        $callable = $this->callback;
        if(is_callable($callable)) {
            $this->authed = $callable($API);
        } else {
            $this->authed = $callable;
        }
        return $this->authed;
    }
    public function getAuthed() {
        return $this->authed;
    }
    public function isAuthed() {
        if(is_object($this->authed) && $this->authed instanceof Response) {
            return false;
        }
        return $this->authed === false ? false : true;
    }
    /**
     * @param API $API
     * @param Route $route
     * @return false|mixed
     */
    public function permissed($API,$route) {
        if(is_null($this->permissedCallback)) {
            return true;
        }
        $callable = $this->permissedCallback;
        if(is_callable($callable)) {
            return $callable($API,$route);
        } else {
            return $callable;
        }
    }


    public function setCallback($callback) {
        $this->callback = $callback;
    }
    public function getCallback() {
        return $this->callback;
    }
    public function setPermissedCallback($callback) {
        $this->permissedCallback = $callback;
    }
    public function getPermissedCallback() {
        return $this->permissedCallback;
    }
}