<?php
namespace boru\dhapi\v2\core;


use boru\dhutils\dhGlobal;

class Container implements \JsonSerializable {
    protected $data = [];
    protected $rawData = [];
    protected $nonPublicFields = [];
    protected $callableKeys = [];

    public function get($key=null,$defaultValue=null) {
        if(is_null($key)) {
            return $this->toArray(false);
        }
        $key = $this->camelKey($key);
        $value = dhGlobal::getVal($this->data,$key,$defaultValue);
        if(is_callable($value)) {
            return $value();
        }
        return $value;
    }
    public function set($key,$value=null,$makePublic=true) {
        if(is_array($key)) {
            $this->data=$key;
            return $this;
        }
        $key = $this->camelKey($key);
        if(strpos($key,".")!==false) {
            if(!$this->dotExists($key)) {
                if(!$makePublic && !in_array($key,$this->nonPublicFields)) {
                    $this->nonPublicFields[] = $key;
                }
            }
            dhGlobal::dotAssign($this->data,$key,$value);
        } else {
            if(!array_key_exists($key,$this->data)) {
                if(!$makePublic && !in_array($key,$this->nonPublicFields)) {
                    $this->nonPublicFields[] = $key;
                }
            }
            $this->data[$key] = $value;
        }
        if(is_callable($value)) {
            $this->callableKeys[] = $key;
        }
    }
    public function getRaw($key=null,$defaultValue=null) {
        if(is_null($key)) {
            return $this->rawData;
        }
        return isset($this->rawData[$key]) ? $this->rawData[$key] : $defaultValue;
    }
    public function setRaw($key,$value=null) {
        if(is_array($key)) {
            $this->rawData=$key;
            return $this;
        }
        $this->rawData[$key] = $value;
        return $this;
    }

    public function toArray($hideNonPublic=true) {
        $data = $this->data;
        if($hideNonPublic) {
            foreach($this->nonPublicFields as $field) {
                dhGlobal::dotDelete($data,$field);
            }
        }
        foreach($this->callableKeys as $callableKey) {
            if($this->dotExists($callableKey)) {
                $value = $this->get($callableKey);
                dhGlobal::dotAssign($data,$callableKey,$value);
            }
        }
        return $data;
    }

    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function setFromArray($array) {
        if(empty($row)) { return false; }
        $this->rawData = $array;
        foreach($row as $key=>$value) {
            //add it to our data set
            $this->set($key,$value,false);
        }
    }
    public function camelKey($key) {
        $parts = explode(".",trim($key));
        $newKey = [];
        for($i=0;$i<count($parts);$i++) {
            $part = $parts[$i];
            $tempKey = $newKey;
            $tempKey[] = $part;
            if(!$this->dotExists(implode(".",$tempKey))) {
                $newPart = dhGlobal::camelize($part);
                $newKey[] = $newPart;
            } else {
                $newKey[] = $part;
            }
        }
        return implode(".",$newKey);
    }
    public function dotExists($dotString) {
        $pieces = explode(".", $dotString);
        $pointer = $this->data;
    
        for ($i = 0; $i < count($pieces); $i++) {
            if (isset($pointer[$pieces[$i]])) {
                $pointer = $pointer[$pieces[$i]];
            } else {
                return false;
            }
        }
        return true;
    }
}