<?php
namespace boru\dhapi\v2\core;

use boru\dhapi\v2\API;
use boru\dhapi\v2\core\Response;
use boru\dhutils\dhGlobal;
use mrr\BaseObject;
use mrr\user\User;

class Request {
    
    protected $data = [];
    private $headers;
    private $method;
    private $path;

    private $apiKey;
    private $apiSignature;
    private $apiNonce;
    
    public function __construct($get,$body,$headers,$method,$path) {
        $data = $this->_cleanInputs($get);
        $data = array_merge($data,$this->_cleanInputs($body));
        $data = $this->_parseDots($data);

        $this->setHeaders($headers);
        $this->setMethod($method);
        $this->setPath($path);
        $this->setData($data);
    }

    public function body($key=null,$defaultValue=null) {
        if($key === null) {
            return $this->data;
        }
        return dhGlobal::getVal($this->data,$key,$defaultValue);
    }
    public function getData() {
        return $this->data;
    }
    public function getHeader($key) {
        $key = strtolower($key);
        if(isset($this->headers[$key])) {
            return $this->headers[$key];
        }
        return null;
    }
    public function getHeaders() {
        return $this->headers;
    }
    public function getMethod() {
        return $this->method;
    }
    public function getPath() {
        return $this->path;
    }

    public function setMethod($method) {
        $this->method = $method;
    }
    public function setPath($path) {
        $this->path = $path;
    }
    public function setData($data) {
        $this->data = $data;
    }

    public function setHeader($key,$value) {
        $key = strtolower($key);
        $this->headers[$key] = $value;
        if($key == "x-api-key") {
            $this->apiKey = $value;
        } elseif($key == "x-api-signature") {
            $this->apiSignature = $value;
        } elseif($key == "x-api-nonce") {
            $this->apiNonce = $value;
        }
    }
    public function setHeaders($headers) {
        foreach($headers as $k=>$v) {
            $this->setHeader($k,$v);
        }
    }

    //utility functions
    private function _cleanInputs($data) {
		$clean_input = Array();
		if (is_array($data)) {
			foreach ($data as $k => $v) {
				if(strpos($k,"_") !== false) {
					$k = str_replace("_",".",$k);
				}
				$clean_input[$k] = $this->_cleanInputs($v);
			}
		} else {
			$clean_input = trim(strip_tags($data));
		}
		return $clean_input;
    }
    private function _parseDots($array) {
		foreach($array as $k=>$v) {
			if(is_array($v)) {
				$array[$k] = $this->_parseDots($v);
			}
			if(strpos($k,".") !== false) {
				$this->_assignArrayByPath($array,$k,$v);
				unset($array[$k]);
			}
		}
		return $array;
	}
	private function _assignArrayByPath(&$arr, $path, $value, $separator='.') {
		$keys = explode($separator, $path);

		foreach ($keys as $key) {
			$arr = &$arr[$key];
		}

		$arr = $value;
	}
}