<?php
namespace boru\dhapi\v2\routing;

use boru\dhapi\v2\core\Response;

class Router {
    private $routes;
    private $regexShortcuts = [
        "id" => [
            "regex" => "[0-9]+",
            "callback" => null,
        ],
        "idlist"=> [
            "regex" => "[0-9,;]+",
            "callback" => "split",
        ],
        "string" => [
            "regex" => "[a-zA-Z0-9]+",
            "callback" => null,
        ],
        "stringlist" => [
            "regex" => "[a-zA-Z0-9,;]+",
            "callback" => "split",
        ],
        "alpha" => [
            "regex" => "[a-zA-Z]+",
            "callback" => null,
        ],
        "alphalist" => [
            "regex" => "[a-zA-Z,;]+",
            "callback" => "split",
        ],
    ];
    private $variableCallbacks = [
        "split" => ["\\boru\\dhapi\\v2\\routing\\Router","splitToArray"],
    ];
    private $authenticationCallback = null;
    private $authenticated = false;
    /**
     * @var Route[] $routes
     */
    public function __construct($routes=[],$authenticationCallaback=null) {
        foreach($routes as $route) {
            $this->add($route);
        }
        if(!is_null($authenticationCallaback)) {
            $this->setAuthenticationCallback($authenticationCallaback);
        }
    }
    public function setAuthenticated($authenticated) {
        $this->authenticated = $authenticated;
    }
    public function getAuthenticated() {
        return $this->authenticated;
    }
    public function setAuthenticationCallback($callback) {
        $this->authenticationCallback = $callback;
    }
    public function getAuthenticationCallback() {
        return is_null($this->authenticationCallback) ? false : $this->authenticationCallback;
    }
    /**
     * @var Route $route
     */
    public function add($route) {
        $route->setRouter($this);
        $this->routes[$route->getName()] = $route;
        return $this;
    }
    public function addClass($className) {
        $routes = Route::fromClass($className);
        foreach($routes as $route) {
            $this->add($route);
        }
    }
    public function addRoute($routeName,$path,$methods,$parameters) {
        $route = new Route($routeName,$path,$methods,$parameters);
        $this->add($route);
        return $this;
    }
    public function addCallback($name,$callback) {
        $this->variableCallbacks[$name] = $callback;
        return $this;
    }
    public function addRegex($name,$regex,$callback=null) {
        $this->regexShortcuts[$name] = [
            "regex" => $regex,
            "callback" => $callback,
        ];
        return $this;
    }
    public function matchFromPath($pathString, $method, $api) {
        foreach ($this->routes as $route) {
            if ($route->match($pathString, $method) === false) {
                continue;
            }
            $permissed = $route->isPermissed($api);
            if($permissed === false) {
                return Response::fromError("Not authorized", 403);
            } elseif($permissed instanceof Response) {
                return $permissed;
            }
            return $route;
        }
        return false;
    }
    

    public function getRegex($name) {
        if(isset($this->regexShortcuts[$name])) {
            return $this->regexShortcuts[$name];
        }
        return ["regex" => "[^/]+", "callback" => null];
    }

    

    public function getVariableCallback($name) {
        if(isset($this->variableCallbacks[$name])) {
            return $this->variableCallbacks[$name];
        }
        return false;
    }
    public static function splitToArray($idInput="") {
        if(empty($idInput)) return [];
        $delims = [",",";"];
        $idInput = str_replace($delims,$delims[0],$idInput);
        return explode($delims[0],$idInput);
    }
}