<?php
namespace boru\dhcache;

use \boru\dhutils\dhGlobal;

class Lock {
    private $cache;
    private $key;
    private $timeout = 0;
    private $locked = false;
    private $value = 1;
    public function __construct($key,$timeout=0,$cache=null) {
        $this->key = $key;
        $this->timeout = $timeout;
        if(is_null($cache)) {
            $cache = dhGlobal::cache();
        }
        $this->cache = $cache;
    }

    public function timeout($timeout=null) {
        if(is_null($timeout)) return $this->timeout;
        $this->timeout = $timeout;
    }
    public function key($key=null) {
        if(is_null($key)) return $this->key;
        $this->key = $key;
    }
    public function cache($cache=null) {
        if(is_null($cache)) return $this->cache;
        $this->cache = $cache;
    }
    public function value($value=null) {
        if(is_null($value)) return $this->value;
        $this->value = $value;
    }
    public function lock() {
        $this->locked = $this->cache->lockVar($this->key,$this->value,$this->timeout);
        return $this->locked;
    }
    public function unlock() {
        if($this->locked) {
            $this->locked = !$this->cache->unlockVar($this->key);
        }
        return !$this->locked;
    }

    /**
     * Locks the lock, runs the callback, then unlocks the lock
     * @param callable $callback callback function to run after lock is acquired
     * @param callable|false|null $errorCallback if null, will throw an exception on timeout
     * @throws \Exception
     */
    public function then($callback,$errorCallback=null) {
        $start = microtime(true);
        while(!$this->lock()) {
            usleep(1000);
            if(microtime(true) - $start > $this->timeout) {
                if($errorCallback === false) {
                    return;
                }
                if(!is_null($errorCallback)) {
                    $errorCallback($this->cache,$this);
                    return;
                } else {
                    throw new \Exception("Lock timeout");
                }
            }
        }
        $return = $callback($this->cache,$this);
        $this->unlock();
        return $return;
    }

    public static function lockThen($key,$callback,$errorCallback=false,$timeout=0,$cache=null) {
        $lock = new Lock($key,$timeout,$cache);
        return $lock->then($callback,$errorCallback);
    }
}