<?php
namespace boru\dhcache\backends;

interface CacheInterface {
    public function get($key,$default=false);
    public function set($key,$value,$expiration=0);
    public function lockVar($key, $value = 1, $expiration = 0);
    public function unlockVar($key);
    public function increment($key, $expiration = 0, $value = 1);
    public function decrement($key, $expiration = 0, $value = 1);
    public function atomicSet($key,$value,$expiration=0);
    public function atomicGet($key);    
}