<?php
namespace boru\dhcache\backends;

use boru\dhutils\dhGlobal;

class Memcached implements CacheInterface {
    public $cache;
    public $prefix = "";
    public $host = 'localhost';
    public $port = 11211;

    public function __construct($options=[]) {
        $prefix = dhGlobal::getVal($options,"prefix","");
        $this->host = dhGlobal::getVal($options,"host","localhost");
        $this->port = dhGlobal::getVal($options,"port",11211);
        $this->cache = new \Memcached();
        $this->cache->addServer($this->host, $this->port);
        $this->prefix = $prefix;
	}

    protected function prefix($key) {
        return $this->prefix.$key;
    }

    public function set($key,$value,$expiration=0) {
        return $this->cache->set($this->prefix($key),$value,$expiration);
    }
    public function get($key,$default=false) {
        return $this->cache->get($this->prefix($key));
    }

    public function lockVar($key, $value = 1, $expiration = 0) {
		return $this->cache->add($this->prefix($key),$value,$expiration);
	}
    public function unlockVar($key) {
		return $this->cache->delete($this->prefix($key));
	}

    public function increment($key, $expiration = 0, $value = 1) {
		$this->lockVar($key,0,$expiration);//create the key if it doesnt exist
		return $this->cache->increment($this->prefix($key), $value);
	}
	
	public function decrement($key, $expiration = 0, $value = 1) {
		$this->lockVar($key,0,$expiration);//create the key if it doesnt exist
		return $this->cache->decrement($this->prefix($key), $value);
	}

    public function atomicSet($key,$value,$expiration=0) {
        $lockKey = "__dhCachelock_".$this->prefix($key);
		$res = $this->cache->add($lockKey,1,10);
        if($res === true) {
            $success = $this->cache->set($this->prefix($key), $value, $expiration);
            $this->cache->delete($lockKey);
            return $success;
        }
        return false;
    }
    public function atomicGet($key) {
        $lockKey = "__dhCachelock_".$this->prefix($key);
		$res = $this->cache->add($lockKey,1,10);
		if($res === true) {
			$data = $this->cache->get($this->prefix($key));
			$this->cache->delete($lockKey);
			return $data;
		}
		return false;
    }

	public function __call($name, $arguments) {
		//if (! $this->enabled) return false;
		//Invoke method $name of $this->cache class with array of $arguments
		return call_user_func_array(array($this->cache, $name), $arguments);
	}
}