<?php
require dirname(__FILE__)."/init.php";

use boru\dhutils\dhGlobal;
use boru\dhcli\dhCLI;

dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE,true,false);

class testObj {
    use \boru\dhutils\traits\CommandRun;
    public function cmd_default($result) {
        echo "cmd_default has result :D\n";
    }
}
$testObj = new testObj();
array_shift($argv);
$dhcli= new dhCLI([
    "name"=>"dhCLI Test 1.0",
    "description"=>"A testing script to process commands",
    "script"=>"php -f test.php "
],$testObj);
$dhcli->command(
    dhCLI::makeCommand([
        "command"=>"run",
        "description"=>"a good description goes here",
        "opts"=>[
            dhCLI::makeOption([
                "short"=>"b",
                "long"=>"book",
                "needsValue"=>true,
                "required"=>true,
                "multiple"=>false,
                "valueFormat"=>"/^[0-9]+$/",
                "description"=>"The playbook.yml file to execute"
            ]),
            dhCLI::makeOption([
                "short"=>"t",
                "long"=>"target",
                "needsValue"=>true,
                "required"=>true,
                "description"=>"The server(s) or groups to run the playbook on"
            ]),
        ],
        "commonOpts" => [
            dhCLI::makeOption([
                "short"=>"n",
                "long"=>"noparse",
                "description"=>"Don't parse the log.. returns ansible's direct output"
            ])
        ],
        "callback"=>function($result) {
            dhGlobal::debug("callback for run");
        },
    ])
);
$dhcli->command(
    dhCLI::makeCommand([
        "command"=>"list",
        "description"=>"list playbooks",
        "callback"=>function($result) {
            dhGlobal::debug("callback for list");
        }
    ])
);
//echo $dhcli->help();
$status = $dhcli->process($argv);
if($status <= 0) {
    //error, we printed errors since it's CLI
} else {
    //success, we did something already..
}
/*
$argstring = "-s -t abc --thisisfun";
$args = new dhcli_args($argstring);
$args->setDebug(true);
$args->parse($opt);
if($opt->hasValue()) {
    echo "We are set\n";
    echo $opt->getValue()."\n";
}
*/