<?php
require dirname(__FILE__)."/init.php";

use boru\dhcli\ClassCommandInterface;
use boru\dhutils\dhGlobal;
use boru\dhcli\dhCLI;
use boru\dhcli\Option;

dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE,true,false);

class testObjCC implements ClassCommandInterface {

    public static function commandName() {
        return "test";
     }

    public static function commandDescription() {
        return "a test command";
    }

    public static function commandOptions() {
        return [
            Option::option("d","database","Database name (optional)",false),
            Option::option("t","threads","(def: 3) Number of threads",false,["default"=>3]),
            Option::flag("i","intraday","Intraday (hourly) backup"),
            Option::flag("s","skipexists","Skip table if it is already present"),
            Option::flag("n","novisual","Hide the thread visualizer"),
            Option::flag("e","extended","Show extended bar in visualizer"),
            Option::flag("", "noheader", "Hide the header"),
            Option::positional("pos1","couple o options here",false),
            Option::positional("pos2","couple o options here",false),
        ];
    }

    public function __construct($result) {
        $test = dhCLI::readLine("Testinput: ",false,true);
        echo $test."\n\n";
        echo "options:\n";
        print_r($result["options"]);
        print_r($result["args"]["unused"]);
    }
}
class testObjCC2 extends testObjCC {
    public static function commandName() {
        return "test2";
     }

    public static function commandDescription() {
        return "a test2 command";
    }
}

dhCLI::init("dhCLI Test 2.0","just a little testing..",[
    "testObjCC",
    "testObjCC2"
]);/*
$dhcli= new dhCLI([
    "name"=>"dhCLI Test 1.0",
    "description"=>"A testing script to process commands",
    "script"=>"php -f test.php "
]);
$dhcli->classCommand("testObjCC");
array_shift($argv);
$dhcli->process($argv);*/