<?php
namespace boru\dhdb;

use boru\dhdb\core\query\QueryParser;
use boru\dhdb\dhDB;
use \boru\dhutils\dhGlobal;

class Query {
    public $rawQueryString;
    /**
     * select, update, insert, delete, union
     */
    public $type;
    public $columns;
    public $tables;
    public $conditions;
    public $values;
    public $groupBy;
    public $orderBy;
    public $limit;
    public $tableMeta;

    public $schemaColumns;

    public $ifNotExists = false;

    public function __construct() {
    }
    public function setQuery($queryString) {
        $this->rawQueryString = $queryString;
    } 
    public function getQuery($interpolate=false) {
        $parser = new QueryParser($this);
		$parser->parse();
		$sql = $parser->getQueryString();
        if($interpolate) {
            $sql = dhDB::interpolateQuery($sql,$this->values);
        }
        return $sql;
    }
    public function insert($i,$v=null) {
        $this->type = "insert";
        return $this->column($i,$v);
    }
    public function select($s) {
        $this->type = "select";
        return $this->column($s);
    }
    public function update($i,$v) {
        $this->type = "update";
        return $this->updateValue($i,$v);
    }
    public function create($t,$ifNotExists=false) {
        $this->type = "create";
        $this->ifNotExists = $ifNotExists;
        return $this->table($t);
    }
    public function alter($t) {
        $this->type = "alter";
        return $this->table($t);
    }
    public function into(...$args) {
        return $this->table(...$args);
    }
    public function from(...$args) {
        return $this->table(...$args);
    }
    public function join(...$args) {
        return $this->table(...$args);
    }
    public function where($c,$v=null) {
        return $this->condition($c,$v);
    }
    public function order($o) {
        $this->orderBy[] = $o;
        return $this;
    }
    public function orderBy($o) {
        $this->orderBy[] = $o;
        return $this;
    }
    public function group($o) {
        $this->groupBy[] = $o;
        return $this;
    }
    public function groupBy($o) {
        $this->groupBy[] = $o;
        return $this;
    }
    public function limit($num,$start=0) {
        $this->limit = [];
        $this->limit[] = $start;
        $this->limit[] = $num;
        return $this;
    }
    public function add($col,$type=null,$extra=null) {
        return $this->schemaColumn("add",$col,$type,$extra);
    }
    public function remove($col) {
        return $this->schemaColumn("drop",$col);
    }
    public function change($col,$newcol,$type=null,$extra=null) {
        return $this->schemaColumn("change",[$col,$newcol],$type,$extra);
    }
    public function addIndex($name,$cols=[],$type="key") {
        return $this->schemaColumn("addIndex",$name,strtolower($type),$cols);
    }
    public function key($name,$cols=[],$type="key") {
        return $this->schemaColumn("addIndex",$name,strtolower($type),$cols);
    }
    public function index($name,$cols=[],$type="key") {
        return $this->schemaColumn("addIndex",$name,strtolower($type),$cols);
    }
    public function dropIndex($name) {
        return $this->schemaColumn("dropIndex",$name);
    }
    public function meta($key,$value=null) {
        if($this->type == "create" || $this->type == "alter") {
            $this->tableMeta[] = ["key"=>$key,"value"=>$value];
        }
        return $this;
    }
    public function schemaColumn($action="add",$col,$type=null,$extra=null) {
        $this->schemaColumns[] = ["action"=>$action,"column"=>$col,"type"=>$type, "extra"=>$extra];
        return $this;
    }
    public function column($c,$v=null,$extraIfAlterOrAdd=null) {
        if($this->type == "create" || $this->type == "alter") {
            return $this->add($c,$v,$extraIfAlterOrAdd);
        } else {
            if(is_array($c)) {
                foreach($c as $col) {
                    $this->columns[] = $col;
                }
            } else {
                $this->columns[] = $c;
            }
            if(!is_null($v)) {
                if(is_array($v)) {
                    foreach($v as $val) {
                        $this->value($v);
                    }
                } else {
                    $this->value($v);
                }
            }
            return $this;
        }
    }
    public function updateValue($c,$v=null) {
        if(!is_array($c) && !is_null($v)) {
            $this->columns[] = $c."=?";
            $this->values[] = $v;
        } else {
            return $this->column($c,$v);
        }
        return $this;
    }
    public function condition($c,$v=null) {
        if(is_array($c)) {
            foreach($c as $col) {
                $this->conditions[] = $c;
            }
        } else {
            $this->conditions[] = $c;
        }
        if(!is_null($v)) {
            if(is_array($v)) {
                foreach($v as $val) {
                    $this->value($val);
                }
            } else {
                $this->value($v);
            }
        }
        return $this;
    }
    public function table($t,$type=null,$on=null) {
        $this->tables[] = ["name"=>$t,"type"=>$type,"on"=>$on];
        return $this;
    }
    public function values($arr) {
        foreach($arr as $v) {
            $this->value($v);
        }
        return $this;
    }
    public function value($v,$vv=null) {
        if(!is_null($vv)) {
            $this->values[$v] = $vv;
        } else {
            if(is_array($v)) {
                return $this->values($v);
            } else {
                $this->values[] = $v;
            }
        }
        return $this;
    }
}