<?php
namespace boru\dhdb\core;

use boru\dhutils\dhGlobal;

class DbConnector {
    public static function connect(array $config) {
        if(!isset($config["dbtype"])) {
            $config["dbtype"] = "mysql";
        }
        $dsn=$config["dbtype"].':host='.$config["dbhost"].";port=".$config["dbport"].";dbname=".$config["dbname"];
        $user=$config["dbuser"];
        $passwd=$config["dbpass"];
        $options = array(
            \PDO::ATTR_PERSISTENT => true, 
            \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION
        );
        $pdo = new \PDO($dsn, $user, $passwd, $options);
        return $pdo;
    }

    public static function fromVtigerConfig($configIncPhpFile) {
        $configFile = dhGlobal::fileIfExists($configIncPhpFile);
        if($configFile !== false) {
            $fileContent = static::cleanCommentsFromString($configFile->content());
            $lines = explode("\n",$fileContent);
            foreach($lines as $ln=>$line) {
                if(preg_match('/^\$dbconfig/', $line)) {
                    
                } else {
                    unset($lines[$ln]);
                }
            }
            $data = implode("\n",$lines);
            $dbconfig = [];
            try {
                eval($data);
            } catch (\Exception $e) {
                return false;
            }
            
        } else {
            global $dbconfig;
            if(!isset($dbconfig) || !is_array($dbconfig) || !isset($dbconfig['db_server'])) {
                throw new \Exception("Could not find VTiger dbconfig in $configIncPhpFile or global scope");
            }
        }
        $config = [
            'dbtype'=>'mysql',
            "dbhost"=>$dbconfig['db_server'],
            "dbport"=>dhGlobal::trimString(":",$dbconfig['db_port'],dhGlobal::TRIM_START),
            "dbuser"=>$dbconfig['db_username'],
            "dbpass"=>$dbconfig['db_password'],
            "dbname"=>$dbconfig['db_name'],
        ];
		return static::connect($config);
    }

    private static function cleanCommentsFromString($string) {
        if (! defined('T_ML_COMMENT')) {
            define('T_ML_COMMENT', T_COMMENT);
        } else {
            if (! defined('T_DOC_COMMENT')) {
                define('T_DOC_COMMENT', T_ML_COMMENT);
            }
        }
        $newStr  = '';
        $commentTokens = [T_COMMENT, T_ML_COMMENT, T_DOC_COMMENT];
        $tokens = token_get_all($string);
        foreach ($tokens as $token) {    
            if (is_array($token)) {
                if (in_array($token[0], $commentTokens)) {
                    continue;
                }   
                $token = $token[1];
            }
            $newStr .= $token;
        }
        return $newStr;
    }
}