<?php
namespace boru\dhdb\core;

use boru\dhdb\contract\RowInterface;

class Row implements RowInterface  {

    public $fields = [];

    public function __construct($fields=[]) {
        if(is_array($fields) && !empty($fields)) {
            $this->fields = $fields;
        }
    }
    public function __set($field,$val) {
        $this->set($field,$val);
    }

    public static function fromStatement($row) {
        if ($row instanceof self) {
            return $row;
        }
        if (is_array($row)) {
            return new self($row);
        }
        return false;
    }


    public function get($column,$default=null) {
        if(isset($this->fields[$column])) {
            return $this->fields[$column];
        }
        return $default;
    }
    public function set($column,$value) {
        $this->fields[$column] = $value;
    }
    public function exists($column=null) {
        if(is_null($column)) {
            return !empty($this->fields);
        }
        return isset($this->fields[$column]);
    }
    public function remove($column) {
        if(isset($this->fields[$column])) {
            unset($this->fields[$column]);
        }
    }

    public function toArray() {
        return $this->fields;
    }
    public function asArray() {
        return $this->fields;
    }
    public function asString() {
        return json_encode($this->fields);
    }
    public function asObject() {
        return (object)$this->fields;
    }

    /**
     * Inherits trait functions from GetSetArray
     * ->get($key,$default=null)
     * ->set($key,$val='',$append=false)
     * ->exists($key=null)
     */

    public function jsonSerialize($array=null) {
        if(is_null($array)) {
            $array = $this->fields;
        }
        return $array;
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetExists($offset) {
        return $this->exists($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetGet($offset) {
        return $this->get($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetSet($offset , $value) {
        $this->set($offset,$value);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetUnset($offset) {
        $this->remove($offset);
    }

    public function __toString() {
        return json_encode($this->fields);
    }
}