<?php
namespace boru\dhdb\parser\expr;

class ConstantExpression extends Expression {
    public function expressionName() {
        return "Constant";
    }
    public function constant() {
        return $this->get("base_expr");
    }
    public function getArray($options=[]) {
        $return["type"] = $this->expressionName();
        if(isset($options["constantAsQuestionMark"]) && $options["constantAsQuestionMark"] === true) {
            $return["constant"] = "?";
        } else {
            $return["constant"] = $this->constant();
        }
        if($this->subTree($options) !== false) {
            $return["subTree"] = $this->subTree($options);
        }
        return $return;
    }
    public function toSql($options=[],&$params=null) {
        $params->addParam($this->constant());
        if(isset($options["constantAsQuestionMark"]) && $options["constantAsQuestionMark"] === true) {
            return "?";
        }
        return $this->constant();
    }
}