<?php
namespace boru\dhdb\traits;

use boru\dhdb\core\DbConnector;

trait DhDbConnectionTrait {

    public function connected() {
        return $this->connect();
    }

    public function connect($config = null) {
        $this->clearError();

        if ($this->pdo instanceof \PDO) {
            return true;
        }

        if (!$config) {
            $config = $this->config;
        }

        try {
            $this->pdo = DbConnector::connect($config);
            return true;
        } catch (\Exception $e) {
            $this->setError($e);
            if ($this->throwExceptions) {
                throw $e;
            }
            return false;
        }
    }

    public function pdo() {
        return $this->pdo;
    }

    public function getPdo() {
        if (!$this->connect()) return null;
        return $this->pdo;
    }

    public function __call($method, $args) {
        if (!$this->connect()) {
            return false; // legacy behavior
        }
        if (!method_exists($this->pdo, $method)) {
            $this->setError("Unknown PDO method: {$method}");
            return false;
        }
        return call_user_func_array([$this->pdo, $method], $args);
    }

    public static function unwrap($db) {
        if ($db instanceof \PDO) return $db;
        if ($db instanceof self) return $db->getPdo();
        return null;
    }
}
