<?php
namespace boru\dhdb\traits;

use boru\dhdb\core\Debugger;

trait DhDbDebugTrait {

    public function printDebug($value = null) {
        return $this->debugger->printDebug($value);
    }
    public function logDebug($value = null) {
        return $this->debugger->logDebug($value);
    }
    public function printError($value = null) {
        return $this->debugger->printError($value);
    }
    public function logError($value = null) {
        return $this->debugger->logError($value);
    }
    public function printSlow($value = null) {
        return $this->debugger->printSlow($value);
    }
    public function logSlow($value = null) {
        return $this->debugger->logSlow($value);
    }
    public function slowLimit($value = null) {
        return $this->debugger->slowLimit($value);
    }
    public function includeTrace($value = null) {
        return $this->debugger->includeTrace($value);
    }

    public function setDebug($options) {
        $this->debugger->setOptions($options);
        return $this;
    }

    /** @return Debugger */
    public function getDebugger() {
        return $this->debugger;
    }
}
