<?php
namespace boru\dhdb\traits;

use boru\dhdb\core\Error;

trait DhDbErrorTrait {

    protected function clearError() {
        $this->error = null;
    }

    /**
     * @param \Exception|string $e
     * @param string $query
     * @param array $params
     * @param string $interpolated
     * @return Error
     */
    protected function setError($e, $query = "", $params = [], $interpolated = "") {
        if ($e instanceof \Exception) {
            $this->error = new Error($query, $params, $interpolated, $e);
        } else {
            $this->error = new Error($query, $params, $interpolated);
            $this->error->setMessage((string)$e);
        }
        return $this->error;
    }

    /** Legacy accessor */
    public function error() {
        if ($this->error instanceof Error) {
            return $this->error->getMessage();
        }
        return null;
    }

    /** Rich accessor */
    public function getError() {
        return ($this->error instanceof Error) ? $this->error : null;
    }
}
