<?php
namespace boru\dhdb\core;

class DebugPrinter {
    public static $hasInjectedStyle=false;
    public static $htmlStyles = '
    <style>
        .dhdb-debugger-line {
            width: 100%;
            display: flex;
        }
        .dhdb-debugger-container {
            width: 100%;
            margin-bottom: 3px;
            /*border-width: 1px 0px;
            border-style: solid;
            border-color: black;*/
            background-color: #ececec;
            font-size: 12px;
            line-height: normal;
        }
        .dhdb-debugger-time {
            width: 60px;
            min-width: 60px;
            max-width: 60px;
            padding-left: 10px;
            padding-right: 10px;
            font-size: 12px;
            line-height: normal;
            background-color: #dbf4db;
        }
        .dhdb-debugger-slow {
            background-color: #fbeac0;
        }
        .dhdb-debugger-query {
            flex-grow: 1;overflow: hidden;text-overflow: ellipsis;
            padding-left: 10px;
        }
        .dhdb-debugger-params {
            flex-grow: 1;overflow: hidden;text-overflow: ellipsis;
        }
        .dhdb-debugger-trace {
            width:100%;background-color: #ececec;
        }
        .dhdb-debugger-error {
            width:100%;background-color: #fbeac0
        }
        .dhdb-debugger-trace-table {
            font-size: 12px;margin-left: 15px;
        }
        .dhdb-debugger-trace-table td, .dhdb-debugger-td,
        .table tbody tr td.dhdb-debugger-td,
        .table-bordered tbody tr td.dhdb-debugger-td,
        .table-bordered tbody:first-child tr:first-child td.dhdb-debugger-td,
        .table tbody:first-child tr:first-child td.dhdb-debugger-td
        {
            padding-left: 5px;
            padding-right: 5px;
            padding-top: 0px;
            padding-bottom: 0px;
            border-top: 1px solid #ccc;
            min-width: 300px;
            overflow: hidden;
            text-overflow: ellipsis;
            text-align: left;
            vertical-align: top;
        }
        .dhdb-debugger-linenumber {
            width: 50px;
            min-width: 50px;
            max-width: 50px;
            text-align: right;
            padding-right: 5px;
            display: table-cell;
        }
        .dhdb-debugger-filename {
            display: table-cell;
        }
    </style>
    ';
    public static $lines = [
        "html" => [
            '<div class="dhdb-debugger-container">',
            '<div class="dhdb-debugger-line">',
            '<div class="dhdb-debugger-time{SLOW_TIME}"><span class="dhdb-debugger-time-value">{TIME}</span>s</div>',
            '<div class="dhdb-debugger-query">{SQLTXT}</div>',
            '<div class="dhdb-debugger-params">{PARAMS}</div>',
            '</div>',
            "{ERROR_LINE}",
            "{TRACE_LINE}",
            '</div>'
        ],
        "text" => [
            "----",
            "{SQLTXT}",
            "{PARAMS}",
            "Exec: {TIME}",
            "{ERROR_LINE}",
            "{TRACE_LINE}",
            "----"
        ],
        "ERROR_LINE" => [
            "html" => '<div class="dhdb-debugger-error">{ERROR_NO}: {ERROR_MSG}</div>',
            "text" => "{ERROR_NO}: {ERROR_MSG}",
        ],
        "TRACE_LINE" => [
            "html" => '<div class="dhdb-debugger-trace">{TRACE}</div>',
            "text" => "{TRACE}"
        ]
    ];

    public static function printHtml($statement,$isSlow=false,$useInterpolate=true) {
        if(!self::$hasInjectedStyle) {
            echo self::$htmlStyles."\n";
            self::$hasInjectedStyle = true;
        }
        $sqlTxt = $paramTxt = "";
        if($useInterpolate) {
            $sqlTxt = $statement->interpolate();
        } else {
            $sqlTxt = $statement->getQuery();
            $paramTxt = static::paramsToString($statement->getParams());
            if(!empty($paramTxt)) {
                $paramTxt = "<code>".$paramTxt."</code>";
            }
        }
        $arr = [];
        $arr["SQLTXT"] = htmlentities($sqlTxt);
        $arr["TIME"] = number_format($statement->getExecTime(),6,".","");
        $arr["PARAMS"] = $paramTxt;
        $arr["TRACE_LINE"] = "";
        $arr["ERROR_LINE"] = "";
        $arr["SLOW_TIME"] = "";
        if($isSlow) {
            $arr["SLOW_TIME"] = ' dhdb-debugger-slow';
        }
        if(!empty($statement->getTrace())) {
            $tempArr = ["TRACE"=>static::traceToString($statement->getTrace())];
            $arr["TRACE_LINE"] = static::parseLine(static::$lines["TRACE_LINE"]["html"],$tempArr);
        }
        if(is_object($statement->getError())) {
            $error = $statement->getError()->toArray();
            $tempArr = ["ERROR_NO"=>$error["code"],"ERROR_MSG"=>$error["message"]];
            $arr["ERROR_LINE"] = static::parseLine(static::$lines["ERROR_LINE"]["html"],$tempArr);
        }
        $printLines = static::parseLines(static::$lines["html"],$arr);
        foreach($printLines as $line) {
            if(!empty($line)) {
                echo $line."\n";
            }
        }
    }
    public static function printText($statement,$isSlow=false,$useInterpolate=true) {
        $sqlTxt = $paramTxt = "";
        if($useInterpolate) {
            $sqlTxt = $statement->interpolate();
        } else {
            $sqlTxt = $statement->getQuery();
            $paramTxt = static::paramsToString($statement->getParams());
        }
        $arr = [];
        $arr["SQLTXT"] = $sqlTxt;
        $arr["TIME"] = number_format($statement->getExecTime(),6,".","");
        $arr["PARAMS"] = $paramTxt;
        $arr["TRACE_LINE"] = "";
        $arr["ERROR_LINE"] = "";
        if(!empty($statement->getTrace())) {
            $tempArr = ["TRACE"=>static::traceToString($statement->getTrace())];
            $arr["TRACE_LINE"] = static::parseLine(static::$lines["TRACE_LINE"]["text"],$tempArr);
        }
        if(is_object($statement->getError())) {
            $error = $statement->getError()->toArray();
            $tempArr = ["ERROR_NO"=>$error["code"],"ERROR_MSG"=>$error["message"]];
            $arr["ERROR_LINE"] = static::parseLine(static::$lines["ERROR_LINE"]["text"],$tempArr);
        }
        $printLines = static::parseLines(static::$lines["text"],$arr);
        foreach($printLines as $line) {
            if(!empty($line)) {
                echo $line."\n";
            }
        }
    }

    private static function parseLines($lines,$vars) {
        foreach($lines as $lnum=>$line) {
            $line = static::parseLine($line,$vars);
            if(empty($line)) {
                unset($lines[$lnum]);
                continue;
            }
            $lines[$lnum] = $line;
        }
        return $lines;
    }
    private static function parseLine($line,$vars) {
        foreach($vars as $k=>$v) {
            if(is_null($v)) $v = "";
            $line = str_replace('{'.$k.'}',$v,$line);
        }
        return $line;
    }
    public static function paramsToString($params) {
        $paramString = '';
        if ($params && !empty($params)) {
            foreach($params as $kk=>$vv) {
                if (is_string($vv) && strlen($vv)>64) $vv = substr($vv,0,64).'...';
                if (is_null($vv)) $paramString .= "($kk=>null) ";
                else $paramString .= "($kk=>'$vv') ";
            }
            $paramString = "[ $paramString ]";
        }
        return $paramString;
    }
    public static function traceToString($trace) {
        $fmt =  "%% line %4d, file: %s func: %s";
        $string = "";
        foreach($trace as $arr) {
            $string .= @sprintf($fmt, $arr['line'],$arr['file'],$arr['func'])."\n";
        }
        return $string;
    }
    public static function traceToTable($trace) {
        $fmt =  '<tr>
            <td class="dhdb-debugger-td">%s</td>
            <td class="dhdb-debugger-td">
                <div class="dhdb-debugger-linenumber">%4d @</div>
                <div class="dhdb-debugger-filename">%s</div>
            </td>
            </tr>';
        $string = '<table class="dhdb-debugger-trace-table">';
        $string .= '<tbody>';
        foreach($trace as $arr) {
            if($arr['func'] == 'Vtiger_WebUI->process()') {
                break;
            }
            $string .= @sprintf($fmt, $arr['func'],$arr['line'],$arr['file'])."\n";
            if(strpos($arr['file'],'templates_c') !== false) {
                break;
            }
        }
        $string.= '</tbody></table>';
        return $string;
    }
}