<?php
namespace boru\dhdb;

use boru\dhdb\core\Debugger;
use boru\dhdb\core\Mysql;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\File;

class dhDB extends Mysql {
	private $debugger = null;
	
	/** @var this */
    private static $instance = null;

    public function __construct($options=[],$static=false) {
        //maintain backward compatibility with the old config format:
        if(isset($options["config"])) {
            $this->setConfig($options["config"]);
        } else {
            $this->setConfig($options);
        }
		$debuggerOpts = [];
		if(isset($_SERVER["HTTP_USER_AGENT"])) {
            $debuggerOpts["isBrowser"] = true;
        }
		$this->debugger = new Debugger($debuggerOpts);
		if($static) {
			static::$instance = $this;
		}
    }
    
	public function query($sql,$params=[],$options=[]) {
        if(!$this->connect()) {
            throw new \Exception("Could not connect to database");
        }
        if($sql instanceof Query) {
            $sql = $this->fromQuery($sql);
        }
        $statement = $this->prepare($sql,$params);
		return $statement->run();
    }
    public function run($sql,$params=[],$options=[]) {
        return $this->query($sql,$params,$options);
    }

	public function printDebug($value=null) {
		return $this->debugger->printDebug($value);
	}
	public function slowLimit($value=null) {
		return $this->debugger->slowLimit($value);
	}
	public function setDebug($options) {
		$this->debugger->setOptions($options);
		return $this;
	}

    public function getDebugger() {
        return $this->debugger;
    }

	//Convinience PDO Wrapper functions simply for IDE autocomplete

	/**
	 * (PHP 5 >= 5.1.0, PHP 7, PECL pdo >= 0.1.0)
	 *
	 * Returns the ID of the last inserted row or sequence value
	 * @return string|false 
	 */
    public function lastInsertId($name=null) {
        return $this->pdo()->lastInsertId($name=null);
    }

	//Static functions

    public static function instance($config=[]) {
        if(is_null(static::$instance) || !empty($config)) {
            static::$instance = new static($config);
        }
        return static::$instance;
    }

    public static function interpolateQuery($query="", $params=[]) {
		if(empty($params)) {
			return $query;
		}
        $keys = array();
		$values = $params;
		# build a regular expression for each parameter
		foreach ($params as $key => $value) {
			if (is_string($key)) {
				$keys[] = '/:'.$key.'/';
			} else {
				$keys[] = '/[?]/';
			}

			if (is_array($value))
				$values[$key] = implode(',', $value);

			if (is_null($value))
				$values[$key] = 'NULL';
		}

		// Walk the array to see if we can add single-quotes to strings
			array_walk($values, function (&$v) {
			if (!is_numeric($v) && $v!="NULL") {
				$v = "\"".$v."\"";
			}
		});

		$query = preg_replace($keys, $values, $query, 1, $count);

		return $query;
    }
	/**
     * Generate an array of [?,?,?,...]
     * 
     * @param array $array the array to count/replace with '?'
     * @param string $glue optional glue to use on the returned string (default ',');
     * @return string
     */
    public static function generateQs($array,$glue=",") {
		$qarr = array_fill(0,count($array),"?");
        return implode($glue,$qarr);
	}

	public static function fromVtigerConfig($configIncPhpFile,$static=true,$options=[]) {
        $configFile = new File(["path"=>$configIncPhpFile]);
        $lineFilter = function($line) {
            if(preg_match('/^\$dbconfig/', $line)) {
                return $line;
            }
        };
        $dbconfig = [];
        $data = $configFile->content(["lineFilter"=>$lineFilter]);
        try {
            eval($data);
        } catch (\Exception $e) {
            return false;
        }
        $config = [
            'dbtype'=>'mysql',
            "dbhost"=>$dbconfig['db_server'],
            "dbport"=>dhGlobal::trimString(":",$dbconfig['db_port'],dhGlobal::TRIM_START),
            "dbuser"=>$dbconfig['db_username'],
            "dbpass"=>$dbconfig['db_password'],
            "dbname"=>$dbconfig['db_name'],
        ];
		if($static) {
			static::$instance = new self($config);
			return static::$instance;
		}
        return new self($config);
    }

	public static function parse($queryString,$opts=[]) {
        $parser = new Parser($queryString);
        $options = [];
        if(isset($opts["params"])) {
            $options["constantAsQuestionMark"]=true;
        }
        if(isset($opts["part"])) {
            $options["part"] = $opts["part"];
        }
        if(isset($opts["array"])) {
            return $parser->toArray($options);
        }
        return $parser->toSql($options);
    }
}