<?php
namespace boru\dhdb\parser\expr;

class ColumnExpression extends Expression {
    public function expressionName() {
        return "Column";
    }
    public function table() {
        if(($noQuotes = $this->get("no_quotes")) !== false && count($noQuotes["parts"]) > 1) {
            return $noQuotes["parts"][0];
        }
        return false;
    }
    public function column() {
        if(($noQuotes = $this->get("no_quotes")) !== false) {
            if(count($noQuotes["parts"]) > 1) {
                return $noQuotes["parts"][1];
            } else {
                return $noQuotes["parts"][0];
            }
        }
        return $this->get("base_expr");
        return false;
    }
    public function alias() {
        $alias = $this->get("alias");
        if(is_array($alias) && isset($alias["no_quotes"])) {
            return $alias["no_quotes"]["parts"][0];
        }
        return $this->get("alias");
    }

    public function getArray($options=[]) {
        $return["type"] = $this->expressionName();
        if($this->table() !== false) {
            $return["table"] = $this->table();
        }
        $return["column"] = $this->column();
        if($this->alias() !== false) {
            $return["alias"] = $this->alias();
        }
        if($this->subTree($options) !== false) {
            $return["subTree"] = $this->subTree($options);
        }
        return $return;
    }

    public function toSql($options=[],&$params=null) {
        $return = "";
        if($this->table() !== false) {
            $return .= "`".$this->table() . "`.";
        }
        if($this->column() == "*") {
            $return .= "*";
            return $return;
        }
        $return .= "`".$this->column()."`";
        if($this->alias() !== false) {
            $return .= " AS " . $this->alias();
        }
        return $return;
    }
}