<?php
namespace boru\dhdb\parser\expr;

use boru\dhutils\dhGlobal;

class ExpressionData implements \JsonSerializable {
    protected $data = [];

    public function __construct($data=[]) {
        if(!empty($data)) {
            $this->setFromArray($data);
        }
    }

    public function has($dotKey) {
        $val = $this->get($dotKey,"_|xzx|_NOT_SET_|xzx|_");
        return $val !== "_|xzx|_NOT_SET_|xzx|_";
    }
    public function get($key=null,$defaultValue=null) {
        if(is_null($key)) {
            return $this->toArray(false);
        }
        if(isset($this->data[$key])) {
            return $this->data[$key];
        }
        return $defaultValue;
    }
    public function set($key,$value=null) {
        if(is_array($key)) {
            $this->data=$key;
            //dhGlobal::parseDots($this->data);
            return $this;
        }
        dhGlobal::dotAssign($this->data,$key,$value);
        return $this;
    }
    
    public function toArray() {
        return $this->data;
    }

    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT);
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    public function setFromArray($array) {
        if(is_object($array) && method_exists($array,"toArray")) {
            $array = $array->toArray();
        }
        if(empty($array)) { return false; }
        $this->data = $array;
        //dhGlobal::parseDots($this->data);
        return $this;
    }
}