<?php
namespace boru\dhdb\parser\expr;

class OperatorExpression extends Expression {
    public function expressionName() {
        return "Operator";
    }
    public function operator() {
        return $this->get("base_expr");
    }
    public function getArray($options=[]) {
        $return = [
            "type"=>$this->expressionName(),
            "operator"=>$this->operator(),
        ];
        if($this->subTree() !== false) {
            $return["subTree"] = $this->subTree();
        }
        return $return;
    }
    public function toSql($options=[],&$params=null) {
        return $this->operator();
    }
}