<?php
namespace boru\dhdb;

use boru\dhdb\parser\expr\Expression;
use boru\dhdb\parser\expr\Params;
use boru\dhdb\parser\SQLParserWrapper;
use boru\dhutils\traits\JsonTrait;

class Parser implements \JsonSerializable {

    use JsonTrait;

    private $query = "";
    private $options = [];
    private $wrapper;

    private $arrayParsed = [];
    private $expressions = [];

    private $dataArray = [];

    public function __construct($query=null,$options=[]) {
        $this->wrapper = new SQLParserWrapper();
        if(!empty($options)) {
            $this->setOptions($options);
        }
        if(!is_null($query)) {
            $this->setQuery($query);
            //$this->parse();
        }
    }

    public function setQuery($query) {
        $this->query = $query;
        $this->parse();
        return $this;
    }
    public function setOptions($options=[],$merge=true) {
        if($merge) {
            $this->options = array_merge($this->options,$options);
        } else {
            $this->options = $options;
        }
        return $this;
    }

    public function getExpressions($type=null) {
        if(!is_null($type)) {
            $type = strtoupper($type);
            if(isset($this->expressions[$type])) {
                return $this->expressions[$type];
            }
        }
        return $this->expressions;
    }

    public function parse($sql=null,$options=[]) {
        if(!is_null($sql)) {
            $this->setQuery($sql);
        }
        if(!empty($options)) {
            $this->setOptions($options);
        }
        $this->dataArray = [];
        $this->wrapper->parse($this->query, $this->options);
        $parsed = $this->wrapper->get();
        $isUnion = false;
        foreach($parsed as $key=>$value) {
            $key = strtoupper($key);
            $this->expressions[$key] = [];
            if($key == "UNION") {
                foreach($value as $union) {
                    $thing = new self($this->wrapper->toQuery($union),$this->options);
                    $this->expressions[$key][] = $thing;
                }
            } else {
                if(is_numeric($key)) {
                    unset($this->expressions[$key]);
                    foreach($value as $k=>$v) {
                        foreach($v as $expr) {
                            $this->expressions[$k][] = Expression::fromArray($expr);
                        }
                    }
                } else {
                    foreach($value as $expr) {
                        $this->expressions[$key][] = Expression::fromArray($expr);
                    }
                }
            }
        }
    }

    public function get($whatPart,$asSql=false) {
        $whatPart = strtoupper($whatPart);
        if(isset($this->expressions[$whatPart])) {
            if($asSql) {
                $sql = [];
                foreach($this->expressions[$whatPart] as $expr) {
                    $sql[] = $expr->toSql();
                }
                return implode(" ",$sql);
            } else {
                return $this->expressions[$whatPart];
            }
        }
        return false;
    }

    public function toArray($options=[]) {
        $sqlArray = [];
        $part = isset($options["part"]) ? $options["part"] : null;
        if(is_null($part)) {
            if(!empty($this->dataArray)) {
                return $this->dataArray;
            }
            foreach($this->expressions as $key=>$value) {
                $sqlArray[$key] = [];
                if($key == "UNION") {
                    foreach($value as $unionNum=>$unionParser) {
                        $sqlArray[$key][] = $unionParser->toArray($options);
                    }
                } else {
                    foreach($value as $expr) {
                        if($expr instanceof Expression) {
                            $sqlArray[$key][] = $expr->toArray($options);
                        } else {
                            $sqlArray[$key][] = $expr;
                        }
                    }
                }
            }
            $this->dataArray = $sqlArray;
        } else {
            $part = strtoupper($part);
            if(isset($this->expressions[$part])) {
                foreach($this->expressions[$part] as $expr) {
                    $sqlArray[] = $expr->toArray($options);
                }
            }
        }
        return $sqlArray;
    }

    public function __toString() {
        return json_encode($this->toArray(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
    }
    public function toString($options=[]) {
        $sqlArray = $this->toArray($options);
        return json_encode($sqlArray,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
    }
    public function toSql($options=[],$params=null) {
        if(is_null($params)) {
            $params = new Params();
        }
        $sqlArray = [];
        $part = isset($options["part"]) ? $options["part"] : null;
        if(is_null($part)) {
            foreach($this->expressions as $key=>$value) {
                $sqlArray[$key] = [];
                if($key === "UNION") {
                    foreach($value as $unionNum=>$unionParser) {
                        $unionSql = $unionParser->toSql($options,$params);
                        $sqlArray[$key][] = $unionSql["sql"];
                    }
                } else {
                    foreach($value as $expr) {
                        if($expr instanceof Expression) {
                            $sqlArray[$key][] = $expr->toSql($options,$params);
                        } else {
                            $sqlArray[$key][] = $expr;
                        }
                    }
                }
            }
            foreach($sqlArray as $key=>$value) {
                if($key == "UNION") {
                    $sqlArray[$key] = implode(" UNION ",$value);
                } else {
                    $sqlArray[$key] = $this->keyToSql($key)." ".implode(" ",$value);
                }
            }
        } else {
            $part = strtoupper($part);
            if(isset($this->expressions[$part])) {
                foreach($this->expressions[$part] as $expr) {
                    if($expr instanceof Expression) {
                        $sqlArray[] = $expr->toSql($options,$params);
                    } else {
                        $sqlArray[] = $expr;
                    }
                }
            }
        }
        if(isset($options["stats"])) {
            
        }
        return ["sql"=>implode(" ",$sqlArray),"params"=>$params->get()];
    }

    public function details($options=[]) {
        $array = $this->toArray($options);
        $details = ["tables"=>[],"columns"=>[],"where"=>[]];
        if(isset($array["UNION"])) {
            //$details = array_merge($details,$array["UNION"][0]->details($options));
        } else {
            if(isset($array["FROM"])) {
                foreach($array["FROM"] as $expr) {
                    if($expr["type"] == "Table") {
                        $details["tables"][] = $expr["table"];
                    }
                }
            }
            if(isset($array["WHERE"])) {
                foreach($array["WHERE"] as $expr) {
                    if($expr["type"] == "Column") {
                        if(isset($expr["table"])) {
                            $details["where"][] = $expr["table"].".".$expr["column"];
                        } else {
                            $details["where"][] = $expr["column"];
                        }
                    }
                }
            }
            if(isset($array["SELECT"])) {
                foreach($array["SELECT"] as $expr) {
                    if($expr["type"] == "Column") {
                        if(isset($expr["table"])) {
                            $details["columns"][] = $expr["table"].".".$expr["column"];
                        } else {
                            $details["columns"][] = $expr["column"];
                        }
                    }
                }
            }
        }
        return $details;
    }

    public function getTables() {
        $tables = [];
        foreach($this->expressions as $key=>$value) {
            if($key == "FROM") {
                foreach($value as $expr) {
                    $tables[] = $expr->getTables();
                }
            }
        }
        return $tables;
    }

    private function keyToSql($key) {
        $key = strtoupper($key);
        if($key == "ORDER") {
            return "ORDER BY";
        }
        return $key;
    }
}